<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\User\Follow;

use Erlage\Photogram\Data\Models\AbstractFinder;
use Erlage\Photogram\Data\Tables\User\UserFollowTable;

final class UserFollowFinder extends AbstractFinder implements InterfaceUserFollowSetter
{
    /**
     * setter interface
     */
    use TraitUserFollowSetters;

    public function getTableName(): string
    {
        return UserFollowTable::getTableName();
    }

    /**
     * @return mixed 
     */
    public function getAtrributeValue(string $attribute)
    {
        return $this -> {UserFollowTable::CAMEL_CASE_MAP[$attribute]}
        ?? null;
    }

    public function popModelFromResults(): UserFollowModel
    {
        return UserFollowModel::createFromUntouchedBean_noException(parent::pop());
    }
}
